local PICKUP_SOUND = {
	Ring 		= "GAME_RINGS",
	Chalice 	= "GAME_PICKUP1",
	Cross 		= "GAME_CROSS",
	Scepter 	= "GAME_SCEPTER",
	Gecko 		= "GAME_PICKUP2",
	Crown 		= "GAME_PICKUP1",
	Skull 		= "GAME_PICKUP1"
}

local SCORE_POINTS = {
	Ring 		= 1500,
	Chalice 	= 2500,
	Cross 		= 5000,
	Scepter 	= 7500,
	Gecko 		= 10000,
	Crown 		= 15000,
	Skull 		= 25000
}

local POINTS_ICON = {
	[100] = 1,
	[500] = 2,
	[1500] = 3,
	[2500] = 4,
	[5000] = 5,
	[7500] = 6,
	[10000] = 7,
	[15000] = 8,
	[25000] = 9
}

function init(self)
	local img = GetImgStr(self.Image)
	local substr = img:sub(1,16)
	if substr ~= "CUSTOM_TREASURE_" then return end
	-- get the treasure name from the image:
	local name = img:match"_(%u+)$"
	self.treasureType = name:sub(1,1):upper() .. name:sub(2,-1):lower()
	-- get the treasure type ID from its name:
	self.treasureTypeID = TreasureType[self.treasureType]

	if self.treasureTypeID then
		RegisterTreasure(self.treasureTypeID)
		self.sound = PICKUP_SOUND[self.treasureType]
		if not self.sound then
			self.sound = "GAME_PICKUP1"
		end
		self.score = SCORE_POINTS[self.treasureType]
		if not self.score then
			self.score = self.Points
			if self.score == 0 then
				self.score = 2500 -- default score points
			end
		end
		self.pointsIcon = POINTS_ICON[self.score]
		self.isStandardTreasure = true
	end
end

function main(self)

	local claw = GetClaw()
	local action = GetMainPlane()

	if self.State == 0 then
		self.AttackFlags.Player = true
		self.AttackRect = {-20, -20, 20, 20}
		self:CreateGlitter()
		self.State = 5
	end

	if self.State == 9000 then
		self:DestroyGlitter()
		PlaySound(self.sound)
		claw.Score = claw.Score + self.score
		if self.isStandardTreasure then
			local collected = PData()["Collected" .. self.treasureType]
			local gcollected = PData()["GameCollected" .. self.treasureType]
			PData()["Collected" .. self.treasureType] = collected + 1
			PData()["GameCollected" .. self.treasureType] = gcollected + 1
		end
		if self.pointsIcon then
			CreateObject{
				x = self.X,
				y = self.Y,
				z = 8900,
				logic = "PointsIcon",
				image = "GAME_POINTS",
				I = self.pointsIcon
			}
		end
		self.SpeedX = -math.random(14,16)
		self.SpeedY = -math.random(14,16)
		self.State = 9001
	end

	if self.State == 9001 then
		self.X = self.X + self.SpeedX
		self.Y = self.Y + self.SpeedY
		if self.X < action.ScreenA.Left or self.Y < claw.Y - action.ScreenA.Top then
			self:Destroy()
		end
	end

end

function attack(self)
	self.State = 9000
	self.AttackFlags.Player = false
end